
@rem --- Set this to the base name of the volume
@set VOLBASE=%1

@rem --- Values used in the pica response file
@set BASEPAL=object2
@set PALKEY=2
@set DITHERTOL=20
@set RENDERSTART=1
@set RENDEREND=254

@echo -======================================
@echo  Building volume file: %VOLBASE%.vol
@echo -======================================

@echo off

rem --- Ensure the correct directory structure ---
 md 8bit
 
rem --- Pica writes frequency info into the pal file ---
copy palettes\%BASEPAL%.pal pica.pal

rem --- Pre-Cleanup ---
 del 8bit\*.*
 del %VOLBASE%.vol
 del pica.vol.rsp

rem --- Create the pica response file - have to respect the batch file ---
 echo quantizeRGB() >> pica.vol.rsp
 echo outputPath(8bit) >> pica.vol.rsp
 echo renderRange(%RENDERSTART%, %RENDEREND%) >> pica.vol.rsp
 echo basePalName(pica.pal) >> pica.vol.rsp
 echo paletteKey(%PALKEY%) >> pica.vol.rsp
 echo extrudeMipLevels() >> pica.vol.rsp
 echo enableDithering() >> pica.vol.rsp
 echo ditherTolerance(%DITHERTOL%) >> pica.vol.rsp
 echo bitmapListStart() >> pica.vol.rsp
 echo %VOLBASE%\*.bmp >> pica.vol.rsp

rem --- Make the 8bit art ---
 ..\bin\picanew @pica.vol.rsp

rem --- Create the Tribes vol file ---
 cd 8bit
 dir /B *.bmp >vt.rsp
 ..\..\bin\vt -sp ..\%VOLBASE%.vol @vt.rsp
 cd ..

rem --- Post-Cleanup ---
 del 8bit\vt.rsp
 del pica.vol.rsp
 del pica.pal
